import 'package:flutter/material.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:percent_indicator/circular_percent_indicator.dart';

import '../../../../../../../domain/models/response/income_statistic_response.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';

class StatisticPage extends StatelessWidget {
  final IncomeStatisticResponse? statistic;

  const StatisticPage({super.key, required this.statistic});

  @override
  Widget build(BuildContext context) {
    return Expanded(
      child: Container(
        height: 415.h,
        padding: const EdgeInsets.symmetric(horizontal: 20, vertical: 30),
        decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(10), color: Style.white),
        child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
          Text(
            AppHelpers.getTranslation(TrKeys.statistics),
            style: Style.interMedium(size: 22),
          ),
          24.verticalSpace,
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Row(
                children: [
                  Container(
                    height: 14,
                    width: 14,
                    decoration: const BoxDecoration(
                      color: Style.blue,
                      shape: BoxShape.circle,
                    ),
                  ),
                  6.horizontalSpace,
                  Text(
                    AppHelpers.getTranslation(TrKeys.accepted),
                    style: Style.interNormal(size: 14),
                  ),
                ],
              ),
              Row(
                children: [
                  Container(
                    height: 14,
                    width: 14,
                    decoration: const BoxDecoration(
                      color: Style.revenueColor,
                      shape: BoxShape.circle,
                    ),
                  ),
                  6.horizontalSpace,
                  Text(
                    AppHelpers.getTranslation(TrKeys.ready),
                    style: Style.interNormal(size: 14),
                  ),
                ],
              ),
              Row(
                children: [
                  Container(
                    height: 14,
                    width: 14,
                    decoration: const BoxDecoration(
                      color: Style.black,
                      shape: BoxShape.circle,
                    ),
                  ),
                  6.horizontalSpace,
                  Text(
                    AppHelpers.getTranslation(TrKeys.onAWay),
                    style: Style.interNormal(size: 14),
                  ),
                ],
              ),
              Row(
                children: [
                  Container(
                    height: 14,
                    width: 14,
                    decoration: const BoxDecoration(
                      color: Style.primary,
                      shape: BoxShape.circle,
                    ),
                  ),
                  6.horizontalSpace,
                  Text(
                    AppHelpers.getTranslation(TrKeys.delivered),
                    style: Style.interNormal(size: 14),
                  ),
                ],
              ),
              Row(
                children: [
                  Container(
                    height: 14,
                    width: 14,
                    decoration: const BoxDecoration(
                      color: Style.red,
                      shape: BoxShape.circle,
                    ),
                  ),
                  6.horizontalSpace,
                  Text(
                    AppHelpers.getTranslation(TrKeys.cancel),
                    style: Style.interNormal(size: 14),
                  ),
                  28.horizontalSpace,
                ],
              ),
            ],
          ),
          const Spacer(),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Container(
                height: 170.h,
                width: 100.w,
                decoration: BoxDecoration(
                    shape: BoxShape.circle, color: Style.blue.withOpacity(0.2)),
                child: CircularPercentIndicator(
                  radius: 50,
                  lineWidth: 8,
                  percent: (statistic?.accepted?.percent?.floor() ?? 0) / 100,
                  center: Text("${statistic?.accepted?.percent?.floor()}%",
                      style: Style.interRegular()),
                  progressColor: Style.blue,
                  backgroundColor: Style.transparent,
                  circularStrokeCap: CircularStrokeCap.round,
                  rotateLinearGradient: true,
                ),
              ),
              Container(
                height: 170.h,
                width: 100.w,
                decoration: BoxDecoration(
                    shape: BoxShape.circle,
                    color: Style.revenueColor.withOpacity(0.2)),
                child: CircularPercentIndicator(
                  radius: 50,
                  lineWidth: 8,
                  percent: (statistic?.ready?.percent?.floor() ?? 0) / 100,
                  center: Text("${statistic?.ready?.percent?.floor()}%",
                      style: Style.interRegular()),
                  progressColor: Style.revenueColor,
                  backgroundColor: Style.transparent,
                  circularStrokeCap: CircularStrokeCap.round,
                  rotateLinearGradient: true,
                ),
              ),
              Container(
                height: 170.h,
                width: 100.w,
                decoration: BoxDecoration(
                    shape: BoxShape.circle,
                    color: Style.black.withOpacity(0.2)),
                child: CircularPercentIndicator(
                  radius: 50,
                  lineWidth: 8,
                  percent: (statistic?.onAWay?.percent?.floor() ?? 0) / 100,
                  center: Text("${statistic?.onAWay?.percent?.floor()}%",
                      style: Style.interRegular()),
                  progressColor: Style.black,
                  backgroundColor: Style.transparent,
                  circularStrokeCap: CircularStrokeCap.round,
                  rotateLinearGradient: true,
                ),
              ),
              Container(
                height: 170.h,
                width: 100.w,
                decoration: BoxDecoration(
                    shape: BoxShape.circle,
                    color: Style.primary.withOpacity(0.2)),
                child: CircularPercentIndicator(
                  radius: 50,
                  lineWidth: 8,
                  percent: (statistic?.delivered?.percent?.floor() ?? 0) / 100,
                  center: Text("${statistic?.delivered?.percent?.floor()}%",
                      style: Style.interRegular()),
                  progressColor: Style.primary,
                  backgroundColor: Style.transparent,
                  circularStrokeCap: CircularStrokeCap.round,
                  rotateLinearGradient: true,
                ),
              ),
              Container(
                height: 170.h,
                width: 100.w,
                decoration: BoxDecoration(
                    shape: BoxShape.circle, color: Style.red.withOpacity(0.2)),
                child: CircularPercentIndicator(
                  radius: 50,
                  lineWidth: 8,
                  percent: (statistic?.canceled?.percent?.floor() ?? 0) / 100,
                  center: Text("${statistic?.canceled?.percent?.floor()}%",
                      style:Style.interRegular()),
                  progressColor: Style.red,
                  backgroundColor: Style.transparent,
                  circularStrokeCap: CircularStrokeCap.round,
                  rotateLinearGradient: true,
                ),
              ),
            ],
          ),
          const Spacer(),
          Text(
            AppHelpers.getTranslation(TrKeys.everyLarge),
            style: Style.interRegular(size: 10),
          ),
          12.verticalSpace,
        ]),
      ),
    );
  }
}
